<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DetalleLiquidacion extends Model 
{

    protected $table = 'detalle_liquidaciones';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('liquidaciones_id', 'valor', 'label', 'distribuidora_id');
    protected $visible = array('liquidaciones_id', 'valor', 'label', 'distribuidora_id');

    public function distribuidora()
    {
        return $this->belongsTo('Distribuidora', 'distribuidora_id')->withTrashed();
    }

    public function liquidacion()
    {
        return $this->belongsTo('Liquidacion', 'liquidacion_id')->withTrashed();
    }

}